package editor;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ListedOverlayImage extends ListedCustomImage {
	
	int transparency;
	Image transparentedImage;
	
	public ListedOverlayImage(BufferedImage theImage, int desiredWidth, int desiredHeight, Color transparentColor, ImageObserver obs, String origFileName) {
		
		super(theImage, desiredWidth, desiredHeight, transparentColor, obs, origFileName);
		transparency = 255;
		transparentedImage = theImage;
		
	}
	
	public void setTransparency(int newTransparency) {
		
		transparency = newTransparency;
		
	}
	
	public int getTransparency() {
		return transparency;
	}
	
	
	
	public static ListedOverlayImage letUserSelectOverlayImage(String title, JFrame parent, ImageObserver io) {
		
		ListedOverlayImage returnValue = new ListedOverlayImage(null,0,0,null,null, null);
		
		FileDialog fd = new FileDialog(parent, title, FileDialog.LOAD);
		
//		System.out.println("about to called fd.setVisible...will it work?");
		
		fd.setVisible(true);
		
//		System.out.println("it just returned from fd.setVisible...file is:  <<" + fd.getFile() + ">>, directory is: <<" + fd.getDirectory() + ">>");
		
		if(fd.getFile() == null || fd.getDirectory() == null) {
//			System.out.println("user clicked cancel!");
			return null;
		}
		
		String fullFileName = fd.getDirectory() + fd.getFile();
		
		BufferedImage theImage = null;
		
		File theFile = new File(fullFileName);
		
		if(!theFile.exists()) {
//			System.out.println("file doesn't exist...I should really add a 'hey doofus!' dialog for this one...");
			
			JOptionPane.showMessageDialog(null, "The specified file did not exist.", "File Error", JOptionPane.ERROR_MESSAGE);
			
			return null;
		}
		
		try {
			theImage = ImageIO.read(theFile);
		} catch (IOException e) {
			// TODO add a dialog to this one.
//			e.printStackTrace();
			
//			System.err.println("there was an IOException while reading this pooch...");
			JOptionPane.showMessageDialog(null, "Error while reading file:  " + e.getMessage(), "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(theImage == null) {
			JOptionPane.showMessageDialog(null, "The given file was not a readable image format:  " + fullFileName, "File Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		returnValue.setRawImage(theImage);
		returnValue.setFileName(fullFileName);
		
		returnValue.setWidth(theImage.getWidth(io));
		returnValue.setHeight(theImage.getHeight(io));
		
		
		return returnValue;
		
	}
	
	
}
